//=============================================================================
// Drop_Items.js
//=============================================================================

/*:
 * @plugindesc ドロップアイテム数や確率を変数で変更できます。
 * @author 村人C
 *
 * @help
 *
 * 使い方
 * コマンド:
 * Drop
 * アイテムの入手数。
 *
 * Common_Rate
 * 通常アイテムを抽選に含む確率。
 *
 * Rare_Rate
 * レアアイテムを抽選に含む確率。
 *
 * 指定した変数の数値が入手数、抽選に含む確率になります。
 * 数値が 0 の場合は、プラグイン側でランダムに選択されます。
 * 変数を利用したくない場合は、 0 を入れて下さい。
 * 変数を利用しない場合もプラグイン側でランダムに選択されます。
 *
 *
 * 敵の「メモ欄」に記述します。
 * 通常ドロップアイテムを３個以上に増やす場合
 * アイテム、武器、防具の名前を入れて下さい。
 * <common_item:
 * ドロップさせたいアイテム名, ドロップさせたいアイテム名,
 * />
 *
 * レアドロップアイテムを増やす場合
 * アイテム、武器、防具の名前を入れて下さい。
 * <rare_item:
 * ドロップさせたいアイテム名, ドロップさせたいアイテム名,
 * />
 *
 * 仕様
 * 敵キャラ設定のドロップアイテムの「出現率」は無視されます。
 *
 *
 * readmeやスタッフロールの明記、使用報告は任意
 *
 * @param Drop
 * @desc 入手数。
 * デフォルト: 10
 * @default 10
 *
 * @param Common_Rate
 * @desc 通常アイテムの入手できる確率。
 * デフォルト: 11
 * @default 11
 *
 * @param Rare_Rate
 * @desc レアアイテムの入手できる確率。
 * デフォルト: 12
 * @default 12
 *
 */

var Drop_Items = Drop_Items || {};
Drop_Items.Drop = []; // 格納用に配列の作成
Drop_Items.Parameters = PluginManager.parameters('Drop_Items');
// 初期設定
Drop_Items.Drop[0] = Number(Drop_Items.Parameters["Drop"]) || 0;
Drop_Items.Drop[1] = Number(Drop_Items.Parameters["Common_Rate"]) || 0;
Drop_Items.Drop[2] = Number(Drop_Items.Parameters["Rare_Rate"])   || 0;
 
(function() {
	//
	Game_Enemy.prototype.makeDropItems = function() {
		// 確率の処理
		if ($gameVariables.value(Drop_Items.Drop[1]) === 0) { // 確率 0
			var rate = Math.floor((Math.random() * 30) * this.dropItemRate()); // 0～30％の確率で入手
		} else {
			var rate = $gameVariables.value(Drop_Items.Drop[1]) * this.dropItemRate();
		}
		// 通常ドロップの処理（データベース）
		var e = this.enemy().dropItems.reduce(function(r, di) {
			if (di.kind > 0 && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
				return r.concat(this.itemObject(di.kind, di.dataId));
			} else {
				return r
			}
		}.bind(this), []);
		// メモ欄取得
		var reg = new RegExp(/<common[-_ ]item:\s*([\s\S]*?)\/>/im);
		if(this.enemy().note.match(reg)){
			var str =this.enemy().note.match(reg)[1]; // 改行時に余計な空白が含まれる
		}
		// 通常
		if (str !== undefined) {
			// アイテムの処理
			var kind = 1;
			var texts = str.split(',');
			for(var n = 0; n < texts.length; n++){
				texts[n] = texts[n].replace(/^\s+|\s+$/g, ""); // 先頭と末尾にある空白文字を一括削除
				for (i in $dataItems) {
					if (i > 0) {
						if ($dataItems[i].name !== "" && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
							if ($dataItems[i].name === texts[n]) {e.push(this.itemObject(kind, $dataItems[i].id));}
						}
					}
				}
			}
			// 武器の処理
			var kind = 2;
			var texts = str.split(',');
			for(var n = 0; n < texts.length; n++){
				texts[n] = texts[n].replace(/^\s+|\s+$/g, ""); // 先頭と末尾にある空白文字を一括削除
				for (i in $dataWeapons) {
					if (i > 0) {
						if ($dataWeapons[i].name !== "" && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
							if ($dataWeapons[i].name === texts[n]) {e.push(this.itemObject(kind, $dataWeapons[i].id));}
						}
					}
				}
			}
			// 防具の処理
			var kind = 3;
			var texts = str.split(',');
			for(var n = 0; n < texts.length; n++){
				texts[n] = texts[n].replace(/^\s+|\s+$/g, ""); // 先頭と末尾にある空白文字を一括削除
				for (i in $dataArmors) {
					if (i > 0) {
						if ($dataArmors[i].name !== "" && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
							if ($dataArmors[i].name === texts[n]) {e.push(this.itemObject(kind, $dataArmors[i].id));}
						}
					}
				}
			}
		}
		// レア
		// 確率の処理
		if ($gameVariables.value(Drop_Items.Drop[2]) === 0) { // 確率 0
			var rate = Math.floor((Math.random() * 10) * this.dropItemRate()); // 0～10％の確率で入手
		} else {
			var rate = $gameVariables.value(Drop_Items.Drop[2]) * this.dropItemRate();
		}
		// メモ欄取得
		var reg = new RegExp(/<rare[-_ ]item:\s*([\s\S]*?)\/>/im);
		if(this.enemy().note.match(reg)){
			var str =this.enemy().note.match(reg)[1]; // 改行時に余計な空白が含まれる
		}
		if (str !== undefined) {
			// アイテムの処理
			var kind = 1;
			var texts = str.split(',');
			for(var n = 0; n < texts.length; n++){
				texts[n] = texts[n].replace(/^\s+|\s+$/g, ""); // 先頭と末尾にある空白文字を一括削除
				for (i in $dataItems) {
					if (i > 0) {
						if ($dataItems[i].name !== "" && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
							if ($dataItems[i].name === texts[n]) {e.push(this.itemObject(kind, $dataItems[i].id));}
						}
					}
				}
			}
			// 武器の処理
			var kind = 2;
			var texts = str.split(',');
			for(var n = 0; n < texts.length; n++){
				texts[n] = texts[n].replace(/^\s+|\s+$/g, ""); // 先頭と末尾にある空白文字を一括削除
				for (i in $dataWeapons) {
					if (i > 0) {
						if ($dataWeapons[i].name !== "" && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
							if ($dataWeapons[i].name === texts[n]) {e.push(this.itemObject(kind, $dataWeapons[i].id));}
						}
					}
				}
			}
			// 防具の処理
			var kind = 3;
			var texts = str.split(',');
			for(var n = 0; n < texts.length; n++){
				texts[n] = texts[n].replace(/^\s+|\s+$/g, ""); // 先頭と末尾にある空白文字を一括削除
				for (i in $dataArmors) {
					if (i > 0) {
						if ($dataArmors[i].name !== "" && rate >= Math.floor(Math.random() * 101)) { // 確率チェック
							if ($dataArmors[i].name === texts[n]) {e.push(this.itemObject(kind, $dataArmors[i].id));}
						}
					}
				}
			}
		}
		return e;
	};
	//
	var _Game_Troop_makeDropItems_CommonRate = Game_Troop.prototype.makeDropItems;
	Game_Troop.prototype.makeDropItems = function() {
		var com = _Game_Troop_makeDropItems_CommonRate.call(this);
		// ドロップ数
		if ($gameVariables.value(Drop_Items.Drop[0]) === 0) { // 入手 0
			var drop = Math.floor(Math.random() * 2); // 0～2個入手
		} else {
			var drop = $gameVariables.value(Drop_Items.Drop[0]);
		}
		var im = [];
		if (com.length > 0 && drop > 0) {
			for (var i = 1; i <= drop; i++) {
				im[i] = com[Math.floor(Math.random() * com.length)];
			}
		}
		return im;
		
	};
	//
})();